"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var KeywordAgileTenderController_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeywordAgileTenderController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const framework_1 = require("../../../../framework");
const allow_roles_decorator_1 = require("../../../../framework/infrastructure/decorators/allow-profiles/allow-roles.decorator");
const api_default_responses_decorator_1 = require("../../../../framework/infrastructure/decorators/api-default-responses/api-default-responses.decorator");
const prime_user_decorator_1 = require("../../../../framework/infrastructure/decorators/prime-user/prime-user.decorator");
const entities_1 = require("../../../domain/entities");
let KeywordAgileTenderController = KeywordAgileTenderController_1 = class KeywordAgileTenderController {
    constructor(keywordAgileTenderService) {
        this.keywordAgileTenderService = keywordAgileTenderService;
        this.LOGGER = new framework_1.PrimeLogger(KeywordAgileTenderController_1.name);
    }
    async findByWord(word) {
        this.LOGGER.log(`Finding agile tender by word: ${word}`);
        return await this.keywordAgileTenderService.getAgileTenderByWord(word);
    }
    async findAdminValues() {
        this.LOGGER.log(`findAdminValues`);
        return await this.keywordAgileTenderService.findAdminValues();
    }
    async findByAgileTenderId(agileTenderId) {
        return this.keywordAgileTenderService.findByAgileTenderId(agileTenderId);
    }
    async logicalRemove(keywordAgileTenderId) {
        this.LOGGER.log(`logicalRemove keyword: ${keywordAgileTenderId}`);
        await this.keywordAgileTenderService.logicalRemove(keywordAgileTenderId);
        return 'true';
    }
    async createKeyword(user, data) {
        this.LOGGER.warn(`createKeyword keyword: ${JSON.stringify(data)} by admin user: ${user.id}`);
        await this.keywordAgileTenderService.save(data, user.id);
        return 'true';
    }
};
exports.KeywordAgileTenderController = KeywordAgileTenderController;
__decorate([
    (0, common_1.Get)('search-word/:word'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: [String] }),
    (0, swagger_1.ApiParam)({ name: 'word', type: 'string' }),
    __param(0, (0, common_1.Param)('word')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], KeywordAgileTenderController.prototype, "findByWord", null);
__decorate([
    (0, common_1.Get)('find-admin-values'),
    (0, swagger_1.ApiOkResponse)({ type: [String] }),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], KeywordAgileTenderController.prototype, "findAdminValues", null);
__decorate([
    (0, common_1.Get)('find-by-agile-tender/:agileTenderId'),
    (0, swagger_1.ApiOkResponse)({ type: [entities_1.AgileKeyword] }),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiParam)({ name: 'agileTenderId', type: 'number' }),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    __param(0, (0, common_1.Param)('agileTenderId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], KeywordAgileTenderController.prototype, "findByAgileTenderId", null);
__decorate([
    (0, common_1.Delete)('logical-remove/:keywordAgileTenderId'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: String }),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiParam)({ name: 'keywordAgileTenderId', type: 'number' }),
    __param(0, (0, common_1.Param)('keywordAgileTenderId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], KeywordAgileTenderController.prototype, "logicalRemove", null);
__decorate([
    (0, common_1.Post)(),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiBody)({ type: entities_1.InsertAgileKeyword }),
    (0, swagger_1.ApiOkResponse)({ type: String }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [framework_1.User,
        entities_1.InsertAgileKeyword]),
    __metadata("design:returntype", Promise)
], KeywordAgileTenderController.prototype, "createKeyword", null);
exports.KeywordAgileTenderController = KeywordAgileTenderController = KeywordAgileTenderController_1 = __decorate([
    (0, common_1.Controller)('keyword-agile-tender'),
    (0, swagger_1.ApiTags)('keyword-agile-tender'),
    __param(0, (0, common_1.Inject)('KeywordAgileTenderService')),
    __metadata("design:paramtypes", [Object])
], KeywordAgileTenderController);
//# sourceMappingURL=keyword-agile-tender.controller.js.map